import sys

def read_input():
    n = int(sys.stdin.readline())
    x = list(map(int, sys.stdin.readline().split()))
    h = list(map(int, sys.stdin.readline().split()))
    return n, x, h

def compute_graph(points):
    edges = []
    for i in range(len(points)):
        for j in range(i+1, len(points)):
            dist = abs(points[i][0] - points[j][0])  
            edges.append((dist, i+1, j+1))
    return edges

def kruskal(n, edges):
    parent = list(range(n+1))
    def find(x):
        while parent[x] != x:
            parent[x] = parent[parent[x]]
            x = parent[x]
        return x
    def union(a, b):
        pa, pb = find(a), find(b)
        if pa != pb:
            parent[pb] = pa
            return True
        return False

    edges.sort(key=lambda e: e[0])
    mst = []
    total_weight = 0
    for w, u, v in edges:
        if union(u, v):
            mst.append((u, v))
            total_weight += w
            if len(mst) == n-1:
                break
    return mst, total_weight

def check_epiphany(tree1, tree2, epsilon):
    pass

def main():
    n, x, h = read_input()
    points = list(zip(x, h))
    edges = compute_graph(points)

    mst, weight = kruskal(n, edges)

    print(n)
    print(" ".join(map(str, x)))
    for u, v in mst:
        print(u, v)

if __name__ == "__main__":
    main()